
import React from 'react';
import { HashRouter, Routes, Route, Navigate } from 'react-router-dom';
import DashboardPage from './pages/DashboardPage';
import CreateFormPage from './pages/CreateFormPage';
import FillFormPage from './pages/FillFormPage';
import ViewSubmissionsPage from './pages/ViewSubmissionsPage';
import ViewGroupSubmissionsPage from './pages/ViewGroupSubmissionsPage'; // New Import
import Navbar from './components/Navbar';

const App: React.FC = () => {
  return (
    <HashRouter>
      <div className="min-h-screen bg-gradient-to-br from-slate-900 to-slate-700 text-gray-100">
        <Navbar />
        <main className="container mx-auto p-4 md:p-8">
          <Routes>
            <Route path="/" element={<DashboardPage />} />
            <Route path="/new-form" element={<CreateFormPage />} />
            <Route path="/edit-form/:formId" element={<CreateFormPage />} /> 
            <Route path="/form/:formId/fill" element={<FillFormPage />} />
            <Route path="/form/:formId/submissions" element={<ViewSubmissionsPage />} />
            <Route path="/group/:groupId/submissions" element={<ViewGroupSubmissionsPage />} /> {/* New Route */}
            <Route path="*" element={<Navigate to="/" replace />} />
          </Routes>
        </main>
        <footer className="text-center p-4 text-sm text-slate-400 border-t border-slate-600">
          Dynamic Form Builder &copy; {new Date().getFullYear()}
        </footer>
      </div>
    </HashRouter>
  );
};

export default App;