<?php
require 'config.php'; // Includes the database connection ($conn)

// Hardcoded admin details
$username = 'jrn.mrt9@gmail.com';
$password_plain = 'ibrahim1994'; // Use a strong password in a real scenario
$role = 'admin';

// Check if the database connection is valid
if (!$conn) {
    die("خطأ فادح: فشل الاتصال بقاعدة البيانات."); // Simple error for direct script execution
}

try {
    // Hash the password securely
    $password_hashed = password_hash($password_plain, PASSWORD_DEFAULT);

    // Prepare the SQL statement (removed allowed_devices)
    $stmt = $conn->prepare("INSERT INTO users (username, password, role) VALUES (:username, :password, :role)");

    // Execute the statement
    $stmt->execute([
        ':username' => $username,
        ':password' => $password_hashed, // Use the hashed password
        ':role' => $role
    ]);

    // Check if the insertion was successful
    if ($stmt->rowCount() > 0) {
        echo "تم إضافة المستخدم '" . htmlspecialchars($username) . "' بصلاحيات admin بنجاح.";
    } else {
        // This might not be reached if execute throws an exception on failure, but good for clarity
        echo "لم يتم إضافة المستخدم. قد يكون هناك خطأ غير متوقع.";
    }

} catch (PDOException $e) {
    // Handle potential errors, like duplicate username
    if ($e->errorInfo[1] == 1062) { // 1062 is the MySQL error code for duplicate entry
        echo "خطأ: اسم المستخدم '" . htmlspecialchars($username) . "' موجود بالفعل.";
    } else {
        // Log the detailed error for the admin
        error_log("Error in add_admin.php: " . $e->getMessage());
        // Show a generic error to the user
        echo "حدث خطأ أثناء إضافة المستخدم: " . htmlspecialchars($e->getMessage()); // Consider showing less detail in production
    }
} finally {
    // Close the connection
    $conn = null;
}

?>
