<?php
// إعدادات الاتصال - Move connection to the top
$host     = "localhost";
$dbname   = "almanxed_almanara_app_db";
$username = "almanxed_almanara_app_db";
$password = "almanara_app_db";
$conn = null; // Initialize $conn to null

try {
    // نحدد في DSN الترميز utf8mb4
    $conn = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // اختياري: تأكيد التعامل بالـ UTF-8
    $conn->exec("SET NAMES 'utf8mb4'");

} catch (PDOException $e) {
    // في حال فشل الاتصال - Log error instead of dying immediately if included mid-page
    // Log the error for server-side debugging
    error_log("Database Connection Error in config.php: " . $e->getMessage());
    // Stop execution and output a JSON error for the client (suitable for APIs)
    http_response_code(500); // Internal Server Error
    // Provide a user-friendly message and avoid exposing raw error details directly
    die(json_encode([
        "status" => "error",
        "message" => "❌ فشل الاتصال بقاعدة البيانات. يرجى المحاولة مرة أخرى لاحقًا أو الاتصال بالمسؤول."
        // "debug_message" => $e->getMessage() // Optionally include detailed error only in a development environment
    ], JSON_UNESCAPED_UNICODE));
}

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// --- التحقق من "تذكرني" ---
// تحقق مما إذا كان المستخدم غير مسجل الدخول ولديه ملفات تعريف الارتباط الخاصة بـ "تذكرني"
// Only proceed if the connection was successful
if ($conn && !isset($_SESSION['user_id']) && isset($_COOKIE['remember_selector']) && isset($_COOKIE['remember_token'])) {
    $selector = $_COOKIE['remember_selector'];
    $token = $_COOKIE['remember_token'];

    try {
        $stmt = $conn->prepare("SELECT * FROM auth_tokens WHERE selector = :selector AND expires >= NOW() LIMIT 1");
        $stmt->execute([':selector' => $selector]);
        $auth_token = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($auth_token && password_verify($token, $auth_token['hashed_token'])) {
            // تم التحقق بنجاح، قم بتسجيل دخول المستخدم
            $stmt_user = $conn->prepare("SELECT * FROM users WHERE id = :user_id LIMIT 1");
            $stmt_user->execute([':user_id' => $auth_token['user_id']]);
            $user = $stmt_user->fetch(PDO::FETCH_ASSOC);

            if ($user) {
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['username'] = $user['username'];
                $_SESSION['role'] = $user['role'];

                // اختياري: إعادة إنشاء التوكن لتوفير أمان إضافي (تجديد الجلسة)
                // يمكنك إضافة منطق هنا لحذف التوكن القديم وإنشاء واحد جديد وتحديث ملفات تعريف الارتباط
            }
        }
        // إذا فشل التحقق أو انتهت صلاحية التوكن، قم بحذف ملفات تعريف الارتباط
        else if ($auth_token) {
            // حذف التوكن من قاعدة البيانات إذا كان موجودًا ولكنه غير صالح
            $stmt_delete = $conn->prepare("DELETE FROM auth_tokens WHERE selector = :selector");
            $stmt_delete->execute([':selector' => $selector]);
        }
        // حذف ملفات تعريف الارتباط من المتصفح
        setcookie('remember_selector', '', time() - 3600, '/', '', isset($_SERVER['HTTPS']), true);
        setcookie('remember_token', '', time() - 3600, '/', '', isset($_SERVER['HTTPS']), true);

    } catch (PDOException $e) {
        error_log("Error checking remember me token: " . $e->getMessage());
        // لا توقف تحميل الصفحة، فقط سجل الخطأ
    }
}
// --- نهاية التحقق من "تذكرني" ---

// Connection established at the top now.
?>
