<?php
header('Content-Type: application/json; charset=UTF-8');
header("Access-Control-Allow-Origin: *");
require 'config.php'; // يتضمن $host, $username, $password, $dbname, $conn (الاتصال الرئيسي PDO)

// --- بداية التعديل: استخدام PDO وجلب اسم الجدول ---

if (!$conn) {
    // تم التعامل مع الخطأ في config.php
    exit();
}

$device_id_input = $_GET['device_id'] ?? null;
if (!$device_id_input) {
    echo json_encode(["status" => "error", "message" => "❌ يرجى تحديد device_id"], JSON_UNESCAPED_UNICODE);
    // لا حاجة لإغلاق الاتصال هنا، PDO يغلقه عند نهاية السكربت
    exit();
}

$device_table_name = null;
$device_name_from_reg = null;

try {
    // 1. البحث عن معلومات الجهاز (اسم الجدول) في الجدول المركزي باستخدام PDO
    $stmt_find_device = $conn->prepare("SELECT table_name, device_name FROM registered_devices WHERE device_id = :device_id");
    if (!$stmt_find_device) {
         error_log("get_latest_location.php: خطأ في تحضير استعلام البحث عن الجهاز: " . print_r($conn->errorInfo(), true));
         throw new Exception("خطأ داخلي في البحث عن الجهاز.");
    }
    $stmt_find_device->bindParam(':device_id', $device_id_input, PDO::PARAM_STR);

    if (!$stmt_find_device->execute()) {
         error_log("get_latest_location.php: خطأ في تنفيذ استعلام البحث عن الجهاز: " . print_r($stmt_find_device->errorInfo(), true));
         $stmt_find_device->closeCursor();
         throw new Exception("خطأ داخلي في البحث عن بيانات الجهاز.");
    }

    $device_info = $stmt_find_device->fetch(PDO::FETCH_ASSOC);
    $stmt_find_device->closeCursor();

    if ($device_info && !empty($device_info['table_name'])) {
        $device_table_name = $device_info['table_name'];
        $device_name_from_reg = $device_info['device_name'];
        error_log("get_latest_location.php: تم العثور على الجهاز '$device_id_input' بجدول '$device_table_name'");
    } else {
        error_log("get_latest_location.php: الجهاز '$device_id_input' غير مسجل أو ليس له اسم جدول.");
        echo json_encode(["status" => "error", "message" => "❌ الجهاز غير مسجل أو بياناته غير مكتملة"], JSON_UNESCAPED_UNICODE);
        exit();
    }

    // 2. جلب أحدث سجل من جدول الجهاز المحدد داخل القاعدة الرئيسية
    // **مهم:** التأكد من أن اسم الجدول آمن
    if (!preg_match('/^device_data_[a-zA-Z0-9_]+$/', $device_table_name)) {
         error_log("get_latest_location.php: اسم الجدول '$device_table_name' غير صالح أو غير آمن.");
         throw new Exception("خطأ داخلي: اسم جدول غير صالح.");
    }

    // لا حاجة لـ USE dbname مع PDO إذا تم تحديده في DSN

    // استخدام backticks لاسم الجدول الديناميكي
    $query = "
        SELECT
            latitude,
            longitude,
            status,
            battery,
            timestamp
        FROM `$device_table_name`
        ORDER BY timestamp DESC
        LIMIT 1
    ";
    error_log("get_latest_location.php: تحضير استعلام جلب آخر موقع من جدول '$device_table_name'...");
    $stmt_latest = $conn->prepare($query);
    if (!$stmt_latest) {
         error_log("get_latest_location.php: خطأ في تحضير استعلام آخر موقع لـ '$device_table_name': " . print_r($conn->errorInfo(), true));
         throw new Exception("خطأ داخلي في تحضير الاستعلام.");
    }

    if (!$stmt_latest->execute()) {
         error_log("get_latest_location.php: خطأ في تنفيذ استعلام آخر موقع لـ '$device_table_name': " . print_r($stmt_latest->errorInfo(), true));
         $stmt_latest->closeCursor();
         throw new Exception("خطأ داخلي في جلب البيانات.");
    }

    $latest_data = $stmt_latest->fetch(PDO::FETCH_ASSOC);
    $stmt_latest->closeCursor();

    // 3. إرجاع النتيجة
    if ($latest_data) {
        // إضافة معلومات الجهاز التي حصلنا عليها من الجدول المركزي
        $latest_data['device_id'] = $device_id_input;
        $latest_data['device_name'] = $device_name_from_reg;
        error_log("get_latest_location.php: تم العثور على آخر موقع للجهاز '$device_id_input'.");
        echo json_encode(["status" => "success", "data" => $latest_data], JSON_UNESCAPED_UNICODE);
    } else {
        error_log("get_latest_location.php: لا توجد بيانات متاحة في جدول '$device_table_name'.");
        echo json_encode(["status" => "error", "message" => "❌ لا توجد بيانات متاحة لهذا الجهاز"], JSON_UNESCAPED_UNICODE);
    }

} catch (PDOException $e) {
     error_log("PDOException في get_latest_location.php: " . $e->getMessage());
     echo json_encode(["status" => "error", "message" => "❌ حدث خطأ في قاعدة البيانات: " . $e->getMessage()], JSON_UNESCAPED_UNICODE);
} catch (Exception $e) {
     error_log("Exception في get_latest_location.php: " . $e->getMessage());
     echo json_encode(["status" => "error", "message" => "❌ حدث خطأ غير متوقع: " . $e->getMessage()], JSON_UNESCAPED_UNICODE);
}

// لا حاجة لإغلاق الاتصال صراحةً مع PDO، سيتم إغلاقه تلقائيًا
// error_log("get_latest_location.php: نهاية السكربت.");

// --- نهاية التعديل ---
?>
