<?php
require 'config.php'; // يتضمن الاتصال بقاعدة البيانات ($conn)

header('Content-Type: text/html; charset=utf-8');

echo "<style>body { font-family: sans-serif; direction: rtl; }</style>";
echo "<h1>تهيئة قاعدة البيانات</h1>";

if (!$conn) {
    echo "<p style='color: red;'>❌ خطأ فادح: لا يمكن الاتصال بقاعدة البيانات. تحقق من إعدادات config.php.</p>";
    exit;
}

// تفعيل عرض الأخطاء المفصلة لـ PDO أثناء التطوير
$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

try {
    // 1. إنشاء جدول المستخدمين (إذا لم يكن موجودًا)
    $sql_users = "CREATE TABLE IF NOT EXISTS users (
        id INT AUTO_INCREMENT PRIMARY KEY,
        username VARCHAR(50) NOT NULL UNIQUE,
        password VARCHAR(255) NOT NULL,
        role ENUM('admin', 'user') DEFAULT 'user',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
    $conn->exec($sql_users);
    echo "<p style='color: green;'>✅ تم التحقق/إنشاء جدول 'users' بنجاح.</p>";

    // 2. إنشاء جدول رموز المصادقة (إذا لم يكن موجودًا)
    $sql_auth_tokens = "CREATE TABLE IF NOT EXISTS auth_tokens (
        id INT AUTO_INCREMENT PRIMARY KEY,
        selector VARCHAR(255) NOT NULL UNIQUE,
        hashed_token VARCHAR(255) NOT NULL,
        user_id INT NOT NULL,
        expires DATETIME NOT NULL,
        FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
    $conn->exec($sql_auth_tokens);
    echo "<p style='color: green;'>✅ تم التحقق/إنشاء جدول 'auth_tokens' بنجاح.</p>";

    // 3. إنشاء جدول الأجهزة المسجلة (إذا لم يكن موجودًا)
    $sql_registered_devices = "CREATE TABLE IF NOT EXISTS registered_devices (
        id INT AUTO_INCREMENT PRIMARY KEY,
        device_id VARCHAR(255) NOT NULL UNIQUE, -- معرف الجهاز الفريد
        device_name VARCHAR(100) NOT NULL,      -- اسم الجهاز удо удо удо
        table_name VARCHAR(100) NOT NULL UNIQUE, -- اسم جدول بيانات الموقع الخاص بالجهاز
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
    $conn->exec($sql_registered_devices);
    echo "<p style='color: green;'>✅ تم التحقق/إنشاء جدول 'registered_devices' بنجاح.</p>";

    // 4. إنشاء جدول مجموعات الأجهزة (إذا لم يكن موجودًا)
    $sql_device_groups = "CREATE TABLE IF NOT EXISTS device_groups (
        id INT AUTO_INCREMENT PRIMARY KEY,
        group_name VARCHAR(100) NOT NULL UNIQUE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
    $conn->exec($sql_device_groups);
    echo "<p style='color: green;'>✅ تم التحقق/إنشاء جدول 'device_groups' بنجاح.</p>";

    // 5. إنشاء جدول أعضاء مجموعات الأجهزة (إذا لم يكن موجودًا)
    $sql_device_group_members = "CREATE TABLE IF NOT EXISTS device_group_members (
        id INT AUTO_INCREMENT PRIMARY KEY,
        group_id INT NOT NULL,
        device_id VARCHAR(255) NOT NULL,
        FOREIGN KEY (group_id) REFERENCES device_groups(id) ON DELETE CASCADE,
        FOREIGN KEY (device_id) REFERENCES registered_devices(device_id) ON DELETE CASCADE,
        UNIQUE KEY unique_group_device (group_id, device_id) -- منع إضافة نفس الجهاز للمجموعة مرتين
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
    $conn->exec($sql_device_group_members);
    echo "<p style='color: green;'>✅ تم التحقق/إنشاء جدول 'device_group_members' بنجاح.</p>";

    echo "<hr><p style='font-weight: bold; color: blue;'>🎉 اكتملت عملية تهيئة قاعدة البيانات بنجاح!</p>";

} catch (PDOException $e) {
    echo "<p style='color: red;'>❌ خطأ أثناء تنفيذ استعلامات SQL: " . htmlspecialchars($e->getMessage(), ENT_QUOTES, 'UTF-8') . "</p>";
}

// لا حاجة لإغلاق الاتصال هنا، PDO يقوم بذلك تلقائيًا
?>