function fetchTimeline() {
    clearMap();
    var deviceId = document.getElementById("deviceSelect").value;
    var date = document.getElementById("dateSelect").value;

    if (!deviceId || !date) {
        alert("⚠️ يرجى اختيار جهاز وتاريخ.");
        return;
    }

    var url = `http://localhost/gps_tracker/get_google_timeline.php?device_id=${deviceId}&date=${date}`;

    fetch(url)
        .then(response => response.json())
        .then(data => {
            console.log("📅 بيانات المخطط الزمني:", data);
            var timelineContainer = document.getElementById("timelineEntries");
            timelineContainer.innerHTML = "";

            if (data.error) {
                alert(data.error);
                return;
            }

            if (data.length > 0) {
                data.forEach(location => {
                    var lat = parseFloat(location.latitude);
                    var lng = parseFloat(location.longitude);
                    var timestamp = location.timestamp;
                    var deviceName = location.device_name;

                    if (!isNaN(lat) && !isNaN(lng)) {
                        var marker = L.marker([lat, lng])
                            .addTo(map)
                            .bindPopup("<b>📍 الموقع:</b> " + deviceName + "<br>⏰ الوقت: " + timestamp);

                        markers.push(marker);

                        var entry = document.createElement("div");
                        entry.classList.add("timeline-entry");
                        entry.innerHTML = `<span class="entry-time">${timestamp}</span> - <b>📍 ${deviceName}</b>`;
                        
                        entry.addEventListener("click", function() {
                            map.setView([lat, lng], 15);
                            marker.openPopup();
                        });

                        timelineContainer.appendChild(entry);
                    }
                });
            } else {
                alert("❌ لا توجد بيانات متاحة لهذا الجهاز في التاريخ المحدد.");
            }
        })
        .catch(error => console.error("⚠️ خطأ في جلب البيانات:", error));
}
