<?php
require 'config.php';

// جلب قائمة الأجهزة الفريدة من قاعدة البيانات
$stmt = $conn->query("SELECT DISTINCT device_id, device_name FROM locations ORDER BY device_name ASC");
$devices = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>📅 مخطط زمني مثل Google Timeline</title>

    <!-- تضمين مكتبة Leaflet -->
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.3/dist/leaflet.css" />
    <script src="https://unpkg.com/leaflet@1.9.3/dist/leaflet.js"></script>

    <style>
        body {
            font-family: Arial, sans-serif;
            text-align: center;
            margin: 0;
            padding: 0;
            background-color: #f8f9fa;
        }
        .header {
            background: #007BFF;
            padding: 15px;
            color: white;
            font-size: 20px;
            font-weight: bold;
        }
        .controls {
            background: white;
            padding: 15px;
            display: flex;
            justify-content: center;
            gap: 10px;
            border-bottom: 2px solid #ddd;
        }
        select, input, button {
            padding: 10px;
            font-size: 16px;
            border-radius: 5px;
            border: 1px solid #ddd;
        }
        button {
            background-color: #007BFF;
            color: white;
            cursor: pointer;
            border: none;
        }
        button:hover {
            background-color: #0056b3;
        }
        #map { 
            height: 500px; 
            width: 90%; 
            margin: 20px auto;
        }
        #timeline {
            margin: 20px auto;
            width: 90%;
            background: white;
            padding: 10px;
            border-radius: 10px;
            box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.2);
            text-align: left;
        }
        .timeline-entry {
            padding: 10px;
            border-bottom: 1px solid #ddd;
            cursor: pointer;
        }
        .timeline-entry:hover {
            background-color: #f1f1f1;
        }
        .entry-time {
            font-weight: bold;
            color: #007BFF;
        }
    </style>
</head>
<body>

    <div class="header">📅 مخطط زمني مثل Google Timeline</div>

    <div class="controls">
        <label>📍 اختر الجهاز:</label>
        <select id="deviceSelect">
            <option value="">جميع الأجهزة</option>
            <?php foreach ($devices as $device): ?>
                <option value="<?= $device['device_id'] ?>"><?= htmlspecialchars($device['device_name']) ?></option>
            <?php endforeach; ?>
        </select>

        <label>📅 اختر التاريخ:</label>
        <input type="date" id="dateSelect">

        <button onclick="fetchTimeline()">🔍 بحث</button>
    </div>

    <div id="map"></div>

    <div id="timeline">
        <h3>📅 المخطط الزمني للأماكن التي زارها الجهاز</h3>
        <div id="timelineEntries"></div>
    </div>

    <script>
        var map = L.map('map').setView([33.3152, 44.3661], 13); // بغداد كموقع افتراضي

        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '&copy; OpenStreetMap contributors'
        }).addTo(map);

        var markers = [];

        function clearMap() {
            markers.forEach(marker => map.removeLayer(marker));
            markers = [];
            document.getElementById("timelineEntries").innerHTML = "";
        }

        function fetchTimeline() {
            clearMap();
            var deviceId = document.getElementById("deviceSelect").value;
            var date = document.getElementById("dateSelect").value;

            if (!deviceId || !date) {
                alert("⚠️ يرجى اختيار جهاز وتاريخ.");
                return;
            }

            var url = `http://localhost/gps_tracker/get_latest_location.php?device_id=${deviceId}&t=${new Date().getTime()}`;


            fetch(url)
                .then(response => response.json())
                .then(data => {
                    console.log("📅 بيانات المخطط الزمني:", data);
                    var timelineContainer = document.getElementById("timelineEntries");

                    if (data.error) {
                        alert(data.error);
                        return;
                    }

                    if (data.length > 0) {
                        data.forEach(location => {
                            var lat = parseFloat(location.latitude);
                            var lng = parseFloat(location.longitude);
                            var timestamp = location.timestamp;

                            if (!isNaN(lat) && !isNaN(lng)) {
                                var marker = L.marker([lat, lng])
                                    .addTo(map)
                                    .bindPopup("<b>📍 الموقع:</b> " + location.device_name + "<br>⏰ الوقت: " + timestamp);

                                markers.push(marker);

                                var entry = document.createElement("div");
                                entry.classList.add("timeline-entry");
                                entry.innerHTML = `<span class="entry-time">${timestamp}</span> - <b>📍 موقع تم زيارته</b>`;
                                
                                entry.addEventListener("click", function() {
                                    map.setView([lat, lng], 15);
                                    marker.openPopup();
                                });

                                timelineContainer.appendChild(entry);
                            }
                        });
                    } else {
                        alert("❌ لا توجد بيانات متاحة لهذا الجهاز في التاريخ المحدد.");
                    }
                })
                .catch(error => console.error("⚠️ خطأ في جلب البيانات:", error));
        }
    </script>

</body>
</html>
