<?php
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

require 'db_connect.php';

// ✅ تأكد من أن الاتصال بقاعدة البيانات يستخدم UTF-8
$conn->set_charset("utf8mb4");

// استقبال البيانات من الطلب
$data = json_decode(file_get_contents("php://input"), true);

if (!$data) {
    error_log("لم يتم استلام أي بيانات");
    echo json_encode(["status" => "error", "message" => "❌ لم يتم استلام أي بيانات"]);
    $conn->close(); // إغلاق الاتصال
    exit;
}

error_log("البيانات المستقبلة: " . print_r($data, true)); // طباعة البيانات في سجلات الخادم لمراقبة الاستقبال

// التحقق من وجود الحقول المطلوبة
$required_fields = ["device_id", "device_name", "latitude", "longitude", "status"];
foreach ($required_fields as $field) {
    if (!isset($data[$field])) {
        error_log("بيانات ناقصة: الحقل المطلوب '$field' غير موجود");
        echo json_encode(["status" => "error", "message" => "❌ بيانات ناقصة: الحقل المطلوب '$field' غير موجود"]);
        $conn->close(); // إغلاق الاتصال
        exit;
    }
}

// تحويل القيم للنص الآمن للقاعدة
$device_id   = $conn->real_escape_string($data["device_id"]);
$device_name = $conn->real_escape_string($data["device_name"]);
$latitude    = $conn->real_escape_string($data["latitude"]);
$longitude   = $conn->real_escape_string($data["longitude"]);
$status      = $conn->real_escape_string($data["status"]);

// في حال كان حقل battery موجودًا في الطلب
$battery = null; 
if (isset($data["battery"])) {
    // يُفترض أنّ battery قيمة رقمية 0-100، أو قد تكون نصًا
    $battery = $conn->real_escape_string($data["battery"]);
}

// 🕒 توليد التوقيت بالتنسيق العراقي (12 ساعة مع AM/PM)
date_default_timezone_set("Asia/Baghdad");
$timestamp = date("Y-m-d h:i:s A");

// إدخال البيانات في قاعدة البيانات
// ملاحظة: يجب أن تكون لديك خانة (عمود) باسم battery في جدول locations
$sql = "INSERT INTO locations (device_id, device_name, latitude, longitude, timestamp, status, battery) 
        VALUES ('$device_id', '$device_name', '$latitude', '$longitude', '$timestamp', '$status', ". 
        ($battery === null ? "NULL" : "'$battery'") . ")";

if ($conn->query($sql) === TRUE) {
    echo json_encode(["status" => "success", "message" => "✅ تم حفظ الموقع بنجاح"]);
} else {
    error_log("خطأ في قاعدة البيانات: " . $conn->error);
    echo json_encode(["status" => "error", "message" => "⚠️ خطأ في قاعدة البيانات: " . $conn->error]);
}

$conn->close(); // إغلاق الاتصال
