<?php
header("Content-Type: application/json; charset=UTF-8");
require 'config.php'; // ملف الاتصال بقاعدة البيانات

try {
    // إعداد الاستعلام لجلب قيمة 'app_url' من جدول 'settings'
    $stmt = $conn->prepare("SELECT setting_value FROM settings WHERE setting_key = 'app_url' LIMIT 1");
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC); // جلب النتيجة كمصفوفة ترابطية

    // إذا تم العثور على النتيجة، استخدمها، وإلا اجعلها null
    $appUrl = $result ? $result['setting_value'] : null;

    // إرجاع الرد كـ JSON
    echo json_encode([
        'status' => 'success',
        'appUrl' => $appUrl ?? '' // إذا كان $appUrl هو null، استخدم سلسلة فارغة
    ], JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    // في حالة حدوث خطأ، أرجع رسالة خطأ كـ JSON
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ]);
}
