<?php
require 'config.php';

// استلام المعاملات من الـ GET
$device_id = isset($_GET['device_id']) ? $_GET['device_id'] : null;
$date = isset($_GET['date']) ? $_GET['date'] : null;
$time_from = isset($_GET['time_from']) ? $_GET['time_from'] : null;
$time_to = isset($_GET['time_to']) ? $_GET['time_to'] : null;

/*
  ستتمّ التصفية في الاستعلام حسب التاريخ والوقت (بصيغة 24 ساعة) في قاعدة البيانات.
  سنضيف أيضًا حقلًا اسمه formatted_time من أجل العرض (صيغة 12 ساعة).
*/

$query = "
    SELECT
        *
    FROM
        locations
    WHERE
        1
";

$params = [];

// تصفية حسب الجهاز
if ($device_id) {
    $query .= " AND device_id = :device_id";
    $params[':device_id'] = $device_id;
}

// تصفية حسب التاريخ (يوم معين)
if ($date) {
    $query .= " AND DATE(timestamp) = :date";
    $params[':date'] = $date;
}

// تصفية حسب الوقت من-إلى
if ($time_from) {
    $query .= " AND TIME(timestamp) >= :time_from";
    $params[':time_from'] = $time_from;
}
if ($time_to) {
    $query .= " AND TIME(timestamp) <= :time_to";
    $params[':time_to'] = $time_to;
}

$query .= " ORDER BY timestamp ASC";

$stmt = $conn->prepare($query);
$stmt->execute($params);
$locations = $stmt->fetchAll(PDO::FETCH_ASSOC);

header("Content-Type: application/json; charset=UTF-8");
echo json_encode($locations, JSON_UNESCAPED_UNICODE);

$conn = null;
?>
