
import React from 'react';
import { Link } from 'react-router-dom';
import { APP_NAME } from '../constants';

const Navbar: React.FC = () => {
  return (
    <nav className="bg-slate-800 shadow-lg">
      <div className="container mx-auto px-4 sm:px-6 lg:px-8">
        <div className="flex items-center justify-between h-16">
          <div className="flex items-center">
            <Link to="/" className="text-2xl font-bold text-sky-400 hover:text-sky-300 transition-colors">
              {APP_NAME}
            </Link>
          </div>
          <div className="flex space-x-4">
            <Link 
              to="/" 
              className="text-gray-300 hover:bg-slate-700 hover:text-white px-3 py-2 rounded-md text-sm font-medium transition-colors"
            >
              Dashboard
            </Link>
            <Link 
              to="/new-form" 
              className="text-gray-300 hover:bg-slate-700 hover:text-white px-3 py-2 rounded-md text-sm font-medium transition-colors"
            >
              Create New Form
            </Link>
          </div>
        </div>
      </div>
    </nav>
  );
};

export default Navbar;
