
export enum FieldType {
  TEXT = 'text',
  NUMBER = 'number',
  EMAIL = 'email',
  DATE = 'date',
  TIME = 'time', // New time field type
  SELECT = 'select',
  TEXTAREA = 'textarea',
  CHECKBOX = 'checkbox', // Single boolean checkbox
  DATETIME_LOCAL = 'datetime-local',
  RADIO_GROUP = 'radio_group',
  CHECKBOX_GROUP = 'checkbox_group', // Multiple selections from options
  FILE = 'file',
  TEL = 'tel',
  URL = 'url',
  PASSWORD = 'password',
  RANGE = 'range',
}

export interface FileValue {
  name: string;
  type: string;
  size: number;
}

export interface ConditionalLogic {
  sourceFieldId: string;    // ID of the field that triggers this one
  triggerOptionValues: string[]; // The specific option values from the source field that trigger visibility
}

export interface DynamicOptionsConfig {
  dependsOnFieldId: string; // ID of the field whose value determines the options for the current field
  optionsMap: { // Key: a value from dependsOnFieldId, Value: array of options for the current field
    [sourceOptionValue: string]: string[];
  };
}

export interface FormFieldDefinition {
  id: string;
  label: string;
  type: FieldType;
  options?: string[]; // For select, radio_group, checkbox_group (static options)
  required?: boolean;
  placeholder?: string;
  // File type specific
  accept?: string; // e.g., "image/*,application/pdf"
  // Range type specific
  min?: number;
  max?: number;
  step?: number;
  // Conditional display logic
  condition?: ConditionalLogic;
  blockedWords?: string[]; // For FieldType.TEXT
  // Dynamic options logic (cascading dropdowns)
  dynamicOptionsConfig?: DynamicOptionsConfig;
}

export interface FormDefinition {
  id: string;
  name: string;
  description?: string;
  fields: FormFieldDefinition[];
  createdAt: string;
}

export interface FormGroup {
  id: string;
  name: string;
  formIds: string[]; // Array of form IDs belonging to this group
  createdAt: string;
}

export interface FormSubmissionData {
  [key: string]: any; // Field ID -> Field Value (can be string, number, boolean, string[], FileValue, or null)
}

export interface FormSubmission {
  id:string;
  formId: string;
  data: FormSubmissionData;
  submittedAt: string;
  latitude?: number;
  longitude?: number;
}

// For Gemini response parsing
export interface SuggestedField {
  label: string;
  type: string; // Will be mapped to FieldType
  options?: string[];
  placeholder?: string;
  accept?: string;
  min?: number;
  max?: number;
  step?: number;
}