<?php
require 'config.php';

header('Content-Type: application/json; charset=UTF-8');
header("Access-Control-Allow-Origin: *");

$device_id = $_GET['device_id'] ?? null;
if (!$device_id) {
    echo json_encode(["status" => "error", "message" => "❌ يرجى تحديد device_id"]);
    exit();
}

try {
    // إذا كنت تخزن بصيغة مثل 2025-02-16 07:09:11 PM فاستخدم النمط التالي:
    $query = "
        SELECT 
            device_id,
            device_name,
            latitude,
            longitude,
            timestamp
        FROM locations
        WHERE device_id = :device_id
        ORDER BY STR_TO_DATE(timestamp, '%Y-%m-%d %h:%i:%s %p') DESC
        LIMIT 1
    ";
    $stmt = $conn->prepare($query);
    $stmt->execute([':device_id' => $device_id]);
    $data = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($data) {
        echo json_encode(["status" => "success", "data" => $data], JSON_UNESCAPED_UNICODE);
    } else {
        echo json_encode(["status" => "error", "message" => "❌ لا توجد بيانات متاحة"], JSON_UNESCAPED_UNICODE);
    }
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "❌ حدث خطأ في قاعدة البيانات: " . $e->getMessage()], JSON_UNESCAPED_UNICODE);
}
?>
