<?php
header("Content-Type: application/json; charset=UTF-8");
require 'config.php'; // ملف الاتصال بقاعدة البيانات

$deviceId = null;
if (isset($_GET['device_id']) && !empty(trim($_GET['device_id']))) {
    $deviceId = trim($_GET['device_id']);
}

$appUrl = null;
$status = 'success';
$message = '';

try {
    // أولاً، حاول جلب الرابط المخصص للجهاز إذا تم توفير device_id
    if ($deviceId) {
        // تحقق مما إذا كان الجهاز موجودًا، إذا لم يكن، قم بتسجيله مبدئيًا
        $check_stmt = $conn->prepare("SELECT id FROM device_specific_urls WHERE device_id = :device_id LIMIT 1");
        $check_stmt->bindParam(':device_id', $deviceId, PDO::PARAM_STR);
        $check_stmt->execute();
        
        if ($check_stmt->rowCount() == 0) {
            // الجهاز غير موجود، قم بإدراجه مبدئيًا بدون رابط مخصص أو اسم ودود
            // سيتم تعيين custom_url و friendly_name لاحقًا عبر لوحة التحكم
            // نجعل custom_url كـ NULL للإشارة إلى أنه لم يتم تعيينه بعد
            $insert_stmt = $conn->prepare("INSERT INTO device_specific_urls (device_id, custom_url, friendly_name) VALUES (:device_id, NULL, NULL)");
            $insert_stmt->bindParam(':device_id', $deviceId, PDO::PARAM_STR);
            try {
                $insert_stmt->execute();
                // لا حاجة لرسالة هنا، هذا يحدث في الخلفية
            } catch (PDOException $e) {
                // سجل الخطأ إذا فشل الإدراج، لكن استمر في محاولة جلب رابط عام
                error_log("Failed to auto-register device ID $deviceId: " . $e->getMessage());
            }
        }

        // الآن، حاول جلب الرابط المخصص للجهاز (قد يكون NULL إذا تم إدراجه للتو)
        $stmt_device = $conn->prepare("SELECT custom_url FROM device_specific_urls WHERE device_id = :device_id LIMIT 1");
        $stmt_device->bindParam(':device_id', $deviceId, PDO::PARAM_STR);
        $stmt_device->execute();
        $result_device = $stmt_device->fetch(PDO::FETCH_ASSOC);

        // استخدم الرابط المخصص فقط إذا كان موجودًا وغير فارغ
        if ($result_device && !empty($result_device['custom_url'])) {
            $appUrl = $result_device['custom_url'];
        }
    }

    // إذا لم يتم العثور على رابط مخصص للجهاز (أو كان NULL/فارغًا)، أو لم يتم توفير device_id، حاول جلب الرابط الافتراضي
    if ($appUrl === null) {
        $stmt_default = $conn->prepare("SELECT setting_value FROM settings WHERE setting_key = 'app_url' LIMIT 1");
        $stmt_default->execute();
        $result_default = $stmt_default->fetch(PDO::FETCH_ASSOC);

        if ($result_default && !empty($result_default['setting_value'])) {
            $appUrl = $result_default['setting_value'];
        } else if ($appUrl === null) { // إذا لم يتم العثور على رابط مخصص ولا رابط افتراضي
             // يمكنك هنا تعيين رابط افتراضي ثابت إذا أردت، أو ترك $appUrl كـ null/فارغ
             // $appUrl = "https://fallback.example.com/form"; 
             // أو إرجاع رسالة خطأ إذا كان الرابط مطلوبًا دائمًا
             // $status = 'error';
             // $message = 'No specific or default URL found.';
        }
    }
    
    // إذا كان $appUrl لا يزال null بعد كل المحاولات
    if ($appUrl === null) {
        $appUrl = ''; // اجعله سلسلة فارغة لتجنب مشاكل JSON
        // إذا لم يتم العثور على أي رابط على الإطلاق (لا مخصص ولا عام)، فهذا يعتبر خطأ
        // لأن التطبيق يتوقع رابطًا إذا كان status هو success
        $status = 'error';
        $message = 'No application URL is configured on the server.';
    }
    
    echo json_encode([
        'status' => $status,
        'appUrl' => $appUrl, // سيكون فارغًا إذا كان status هو 'error' بسبب عدم وجود رابط
        'message' => $message 
    ], JSON_UNESCAPED_UNICODE | JSON_NUMERIC_CHECK);

} catch (PDOException $e) { // كن أكثر تحديدًا مع استثناءات PDO
    error_log("Database Error: " . $e->getMessage()); // سجل الخطأ في الخادم
    echo json_encode([
        'status' => 'error',
        'appUrl' => '', // أرجع رابطًا فارغًا في حالة الخطأ
        'message' => 'Database connection or query error.' // رسالة عامة للمستخدم
        // 'message' => $e->getMessage() // لا تعرض رسائل خطأ مفصلة للمستخدم في الإنتاج
    ]);
} catch (Exception $e) { // لأي استثناءات أخرى
    error_log("General Error: " . $e->getMessage());
    echo json_encode([
        'status' => 'error',
        'appUrl' => '',
        'message' => 'An unexpected error occurred.'
        // 'message' => $e->getMessage()
    ]);
}
