<?php
session_start(); // بدء الجلسة (مهم للأمان لاحقًا، مثل التحقق من تسجيل الدخول)
require 'config.php'; // ملف الاتصال بقاعدة البيانات

// رسالة للمستخدم (للنجاح أو الخطأ)
$user_message = '';
$edit_mode = false;
$edit_data = ['id' => '', 'device_id' => '', 'custom_url' => '', 'friendly_name' => ''];

// جلب جميع الأجهزة لملء القائمة المنسدلة
$all_devices_for_select = [];
try {
    $stmt_all_devices = $conn->query("SELECT id, device_id, friendly_name FROM device_specific_urls ORDER BY friendly_name, device_id");
    if($stmt_all_devices){
        $all_devices_for_select = $stmt_all_devices->fetchAll(PDO::FETCH_ASSOC);
    }
} catch (PDOException $e) {
    // لا تعرض خطأ هنا مباشرة، قد يؤثر على عرض الصفحة
    error_log("Error fetching all devices for select: " . $e->getMessage());
}


// التحقق إذا كان في وضع التعديل (عبر GET من الجدول أو من القائمة المنسدلة)
$current_action = $_GET['action'] ?? null;
$current_id = isset($_GET['id']) ? intval($_GET['id']) : (isset($_GET['selected_device_record_id']) ? intval($_GET['selected_device_record_id']) : null);

if (($current_action == 'edit' || $current_action == 'edit_from_select') && $current_id !== null) {
    try {
        $stmt_edit = $conn->prepare("SELECT id, device_id, custom_url, friendly_name FROM device_specific_urls WHERE id = :id");
        $stmt_edit->bindParam(':id', $current_id, PDO::PARAM_INT);
        $stmt_edit->execute();
        $data = $stmt_edit->fetch(PDO::FETCH_ASSOC);
        if ($data) {
            $edit_mode = true;
            $edit_data = $data;
        } else {
            $user_message = "خطأ: لم يتم العثور على السجل للتعديل (ID: $current_id).";
        }
    } catch (PDOException $e) {
        $user_message = "خطأ في جلب بيانات التعديل: " . $e->getMessage();
    }
}


// التحقق مما إذا كان النموذج قد تم إرساله (إضافة أو تحديث)
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // device_id_post قد يأتي من حقل نصي (إذا كان النموذج يسمح بذلك للإضافة الجديدة)
    // أو يجب أن يتم تحديده بناءً على record_id_post إذا كنا نعدل
    $device_id_post = trim($_POST['device_id_hidden_for_update'] ?? $_POST['new_device_id'] ?? ''); //  تعديل هنا
    $custom_url_post = trim($_POST['custom_url'] ?? '');
    $friendly_name_post = trim($_POST['friendly_name'] ?? '');
    $record_id_post = isset($_POST['record_id']) ? intval($_POST['record_id']) : null; // هذا هو ID السجل الذي يتم تعديله

    if (isset($_POST['add_or_update_url'])) {
        // إذا كان record_id_post موجودًا، فنحن في وضع التحديث لجهاز محدد.
        // device_id_post في هذه الحالة يجب أن يكون هو device_id الخاص بهذا السجل (يأتي من device_id_hidden_for_update).
        if ($record_id_post) {
             if (empty($device_id_post)) { // يجب أن يكون device_id موجودًا إذا كان record_id موجودًا
                $device_id_post = $edit_data['device_id']; // استرجاعه من البيانات المحملة مسبقًا
            }
        } else {
            // هذا هو وضع الإضافة لجهاز جديد (يجب أن يأتي device_id من new_device_id)
            $device_id_post = trim($_POST['new_device_id'] ?? '');
        }


        if (!empty($device_id_post) && !empty($custom_url_post)) {
            try {
                if ($record_id_post) { // وضع التحديث بناءً على ID السجل
                    $sql = "UPDATE device_specific_urls SET custom_url = :custom_url, friendly_name = :friendly_name WHERE id = :id";
                    // لا نقم بتحديث device_id هنا، لأنه مفتاح فريد ويجب التعامل معه بحذر
                    // إذا كان يجب تحديث device_id، فهذا يتطلب منطقًا أكثر تعقيدًا أو عملية منفصلة
                    $stmt = $conn->prepare($sql);
                    $stmt->bindParam(':id', $record_id_post, PDO::PARAM_INT);
                    // $stmt->bindParam(':device_id', $device_id_post); // تم إزالته مؤقتًا لتجنب مشاكل تحديث المفتاح الفريد
                } else { // وضع الإضافة لجهاز جديد
                    $sql = "INSERT INTO device_specific_urls (device_id, custom_url, friendly_name) 
                            VALUES (:device_id, :custom_url, :friendly_name)
                            ON DUPLICATE KEY UPDATE custom_url = VALUES(custom_url), friendly_name = VALUES(friendly_name)";
                            // ON DUPLICATE KEY UPDATE هنا سيعمل إذا كان device_id الذي تم إدخاله كجديد موجودًا بالفعل
                    $stmt = $conn->prepare($sql);
                    $stmt->bindParam(':device_id', $device_id_post); // هنا نستخدم device_id من الإدخال الجديد
                }
                
                $stmt->bindParam(':custom_url', $custom_url_post);
                $stmt->bindParam(':friendly_name', $friendly_name_post);
                
                if ($stmt->execute()) {
                    $user_message = "تمت " . ($record_id_post ? "تحديث" : "إضافة/تحديث") . " الرابط للجهاز '$device_id_post' بنجاح!";
                    $edit_mode = false; 
                    $edit_data = ['id' => '', 'device_id' => '', 'custom_url' => '', 'friendly_name' => ''];
                    // إعادة توجيه لتنظيف النموذج وتجنب إعادة الإرسال عند التحديث
                    header("Location: " . $_SERVER["PHP_SELF"]);
                    exit;
                } else {
                    $user_message = "خطأ: لم يتمكن من تنفيذ الاستعلام.";
                }
            } catch (PDOException $e) {
                $user_message = "خطأ في قاعدة البيانات: " . $e->getMessage();
                if ($e->getCode() == '23000') { 
                    $user_message .= "<br>قد يكون معرف الجهاز الذي تحاول إضافته مكررًا.";
                }
            }
        } else {
            $user_message = "خطأ: معرف الجهاز (إذا كنت تضيف جديدًا) والرابط المخصص مطلوبان.";
        }
    }
}


// جلب جميع الروابط المخصصة لعرضها
$device_urls = [];
try {
    $sql_select = "SELECT id, device_id, custom_url, friendly_name, created_at, updated_at FROM device_specific_urls ORDER BY updated_at DESC, created_at DESC";
    $stmt_select = $conn->query($sql_select);
    if($stmt_select){
        $device_urls = $stmt_select->fetchAll(PDO::FETCH_ASSOC);
    }
} catch (PDOException $e) {
    $user_message .= "<br>خطأ في جلب الروابط: " . $e->getMessage(); // أضف إلى الرسالة الموجودة
}

?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إدارة روابط الأجهزة المخصصة</title>
    <style>
        body { font-family: sans-serif; margin: 20px; background-color: #f4f4f4; color: #333; }
        .container { background-color: #fff; padding: 20px; border-radius: 8px; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
        h1, h2 { color: #333; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: right; }
        th { background-color: #e9e9e9; }
        form div { margin-bottom: 10px; }
        label { display: block; margin-bottom: 5px; }
        input[type="text"], input[type="url"] { width: calc(100% - 22px); padding: 10px; border: 1px solid #ccc; border-radius: 4px; }
        input[type="submit"] { background-color: #007bff; color: white; padding: 10px 15px; border: none; border-radius: 4px; cursor: pointer; }
        input[type="submit"]:hover { background-color: #0056b3; }
        .message { padding: 10px; margin-bottom: 15px; border-radius: 4px; }
        .success { background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
        .error { background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
        /* يمكنك إضافة المزيد من الأنماط لتحسين المظهر */
    </style>
</head>
<body>
    <div class="container">
        <h1>إدارة روابط الأجهزة المخصصة</h1>

        <?php if (!empty($user_message)): ?>
            <div class="message <?php echo (strpos(strtolower($user_message), 'خطأ') !== false || strpos(strtolower($user_message), 'error') !== false) ? 'error' : 'success'; ?>">
                <?php echo htmlspecialchars($user_message); ?>
            </div>
        <?php endif; ?>

        <h2><?php echo $edit_mode ? 'تعديل بيانات الجهاز: ' . htmlspecialchars($edit_data['friendly_name'] ?: $edit_data['device_id']) : 'إدارة الأجهزة'; ?></h2>
        
        <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="get" id="selectDeviceForm" style="margin-bottom: 20px;">
            <input type="hidden" name="action" value="edit_from_select">
            <div>
                <label for="selected_device_record_id">اختر جهازًا لتعديله:</label>
                <?php if (empty($all_devices_for_select)): ?>
                    <p style="color: #721c24; background-color: #f8d7da; border: 1px solid #f5c6cb; padding: 10px; border-radius: 4px;">
                        لا توجد أجهزة مسجلة حاليًا في جدول `device_specific_urls`. 
                        يرجى التأكد من أن تطبيق Flutter قد اتصل بالخادم مرة واحدة على الأقل ليسجل الجهاز، 
                        أو قم بإضافة جهاز يدويًا باستخدام النموذج أدناه إذا كنت تعرف معرف الجهاز.
                    </p>
                <?php else: ?>
                    <select name="selected_device_record_id" id="selected_device_record_id" onchange="document.getElementById('selectDeviceForm').submit();">
                        <option value="">-- اختر جهاز --</option>
                        <?php foreach ($all_devices_for_select as $device_opt): ?>
                            <option value="<?php echo htmlspecialchars($device_opt['id']); ?>" <?php echo ($edit_mode && isset($edit_data['id']) && $edit_data['id'] == $device_opt['id']) ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars(!empty($device_opt['friendly_name']) ? $device_opt['friendly_name'] : $device_opt['device_id']); ?>
                                (<?php echo htmlspecialchars($device_opt['device_id']); ?>)
                            </option>
                        <?php endforeach; ?>
                    </select>
                <?php endif; ?>
            </div>
        </form>

        <hr>
        <h3><?php echo $edit_mode ? 'تعديل تفاصيل الجهاز المختار' : 'إضافة جهاز جديد (إذا لم يكن مسجلاً بعد)'; ?></h3>
        <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]) . ($edit_mode ? '?action=edit&id='.$edit_data['id'] : ''); ?>" method="post">
            <?php if ($edit_mode && !empty($edit_data['id'])): ?>
                <input type="hidden" name="record_id" value="<?php echo htmlspecialchars($edit_data['id']); ?>">
                <input type="hidden" name="device_id_hidden_for_update" value="<?php echo htmlspecialchars($edit_data['device_id']); ?>">
                 <div>
                    <label>معرف الجهاز (Device ID):</label>
                    <input type="text" value="<?php echo htmlspecialchars($edit_data['device_id']); ?>" readonly>
                    <small>(لا يمكن تغيير معرف الجهاز من هنا)</small>
                </div>
            <?php else: // وضع الإضافة لجهاز جديد ?>
                <div>
                    <label for="new_device_id">معرف الجهاز (Device ID) الجديد:</label>
                    <input type="text" id="new_device_id" name="new_device_id" value="" placeholder="أدخل معرف الجهاز إذا كان جديدًا وغير مسجل">
                </div>
            <?php endif; ?>
           
            <div>
                <label for="custom_url">الرابط المخصص (Custom URL):</label>
                <input type="url" id="custom_url" name="custom_url" value="<?php echo htmlspecialchars($edit_data['custom_url']); ?>" <?php echo $edit_mode ? '' : 'required';?> placeholder="https://example.com/form-for-device">
                 <small><?php echo $edit_mode ? '' : 'مطلوب إذا كنت تضيف جهازًا جديدًا أو تحدث رابطًا.';?></small>
            </div>
            <div>
                <label for="friendly_name">الاسم الودود (اختياري):</label>
                <input type="text" id="friendly_name" name="friendly_name" value="<?php echo htmlspecialchars($edit_data['friendly_name']); ?>" placeholder="مثال: هاتف أحمد">
            </div>
            <div>
                <input type="submit" name="add_or_update_url" value="<?php echo $edit_mode ? 'حفظ التعديلات' : 'إضافة جهاز جديد / تحديث بالمعرف أعلاه'; ?>">
                <?php if ($edit_mode): ?>
                    <a href="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" style="margin-right: 10px;">إلغاء وإظهار نموذج الإضافة</a>
                <?php endif; ?>
            </div>
        </form>
        <?php // </form>  Tag إضافي تم حذفه من هنا, الـ div container يغلق لاحقًا ?>

        <h2>الروابط المخصصة الحالية</h2>
        <?php if (count($device_urls) > 0): ?>
            <table>
                <thead>
                    <tr>
                        <th>معرف الجهاز</th>
                        <th>الاسم الودود</th>
                        <th>الرابط المخصص</th>
                        <th>تاريخ التحديث</th>
                        <th>إجراءات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($device_urls as $row): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($row['device_id']); ?></td>
                            <td><?php echo htmlspecialchars($row['friendly_name'] ?? '-'); ?></td>
                            <td>
                                <?php if (!empty($row['custom_url'])): ?>
                                    <a href="<?php echo htmlspecialchars($row['custom_url']); ?>" target="_blank"><?php echo htmlspecialchars($row['custom_url']); ?></a>
                                <?php else: ?>
                                    (لم يتم التعيين)
                                <?php endif; ?>
                            </td>
                            <td><?php echo htmlspecialchars($row['updated_at']); ?></td>
                            <td>
                                <a href="?action=edit&id=<?php echo $row['id']; ?>">تعديل</a>
                                <!-- يمكنك إضافة رابط للحذف هنا لاحقًا -->
                                <!-- &nbsp;|&nbsp; <a href="?action=delete&id=<?php echo $row['id']; ?>" onclick="return confirm('هل أنت متأكد من حذف هذا السجل؟')">حذف</a> -->
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php else: ?>
            <p>لا توجد روابط مخصصة حاليًا.</p>
        <?php endif; ?>
    </div>
</body>
</html>
