<?php
require 'config.php';

// التحقق من أن المستخدم مسجل دخول وهو أدمن
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: login.php");
    exit;
}

$message = '';

// معالجة إضافة مستخدم جديد
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    // إضافة مستخدم جديد
    if ($_POST['action'] === 'add_user') {
        $new_username = trim($_POST['new_username']);
        $new_password = $_POST['new_password'];
        $new_role = $_POST['new_role'];
        $allowed_devices = isset($_POST['allowed_devices']) ? implode(',', $_POST['allowed_devices']) : '';
        
        $stmt = $conn->prepare("SELECT id FROM users WHERE username = :username");
        $stmt->execute(['username' => $new_username]);
        if ($stmt->fetch()) {
            $message = "اسم المستخدم موجود بالفعل.";
        } else {
            $hashed = password_hash($new_password, PASSWORD_DEFAULT);
            $stmt = $conn->prepare("INSERT INTO users (username, password, role, allowed_devices) VALUES (:username, :password, :role, :allowed_devices)");
            $stmt->execute([
                'username' => $new_username,
                'password' => $hashed,
                'role' => $new_role,
                'allowed_devices' => $allowed_devices
            ]);
            $message = "تم إضافة المستخدم بنجاح.";
        }
    }
    
    // حذف المستخدم
    if ($_POST['action'] === 'delete_user' && isset($_POST['user_id'])) {
        $user_id = $_POST['user_id'];
        if ($user_id == $_SESSION['user_id']) {
            $message = "لا يمكن حذف الحساب الحالي.";
        } else {
            $stmt = $conn->prepare("DELETE FROM users WHERE id = :id");
            $stmt->execute(['id' => $user_id]);
            $message = "تم حذف المستخدم بنجاح.";
        }
    }
    
    // تحديث الأجهزة المسموح بها للمستخدم
    if ($_POST['action'] === 'update_devices' && isset($_POST['user_id'])) {
        $user_id = $_POST['user_id'];
        $allowed_devices = isset($_POST['allowed_devices']) ? implode(',', $_POST['allowed_devices']) : '';
        $stmt = $conn->prepare("UPDATE users SET allowed_devices = :allowed_devices WHERE id = :id");
        $stmt->execute(['allowed_devices' => $allowed_devices, 'id' => $user_id]);
        $message = "تم تحديث الأجهزة المسموح بها للمستخدم بنجاح.";
    }
}

// جلب كافة الأجهزة من جدول locations
$stmt_devices = $conn->query("SELECT DISTINCT device_id, device_name FROM locations ORDER BY device_name ASC");
$all_devices = $stmt_devices->fetchAll(PDO::FETCH_ASSOC);

// جلب كافة المستخدمين
$stmt_users = $conn->query("SELECT id, username, role, allowed_devices FROM users ORDER BY username ASC");
$users = $stmt_users->fetchAll(PDO::FETCH_ASSOC);

// التحقق من طلب تعديل الأجهزة لمستخدم معين
$editUser = null;
if (isset($_GET['edit_user'])) {
    $edit_user_id = $_GET['edit_user'];
    $stmt_edit = $conn->prepare("SELECT id, username, allowed_devices FROM users WHERE id = :id");
    $stmt_edit->execute(['id' => $edit_user_id]);
    $editUser = $stmt_edit->fetch(PDO::FETCH_ASSOC);
}
?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>لوحة تحكم الأدمن</title>
    <style>
        /* القواعد العامة */
        * {
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #1f1f1f;
            color: #e0e0e0;
            margin: 0;
            padding: 20px;
        }
        h2, h3 {
            text-align: center;
            margin-bottom: 15px;
            font-weight: 500;
        }
        .message {
            text-align: center;
            color: #ff6b6b;
            margin-bottom: 20px;
            font-size: 16px;
        }
        /* تنسيق النماذج */
        form {
            background: #2c2c2c;
            padding: 20px;
            border-radius: 8px;
            max-width: 500px;
            margin: 20px auto;
            box-shadow: 0 2px 10px rgba(0,0,0,0.3);
        }
        form label {
            display: block;
            margin: 10px 0 5px;
            font-weight: bold;
            color: #fff;
        }
        input, select {
            width: 100%;
            padding: 10px;
            margin-bottom: 10px;
            border-radius: 4px;
            border: 1px solid #444;
            background: #383838;
            color: #e0e0e0;
        }
        select[multiple] {
            height: auto;
        }
        button, a.button {
            display: block;
            width: 100%;
            padding: 10px;
            background: #007BFF;
            border: none;
            color: #fff;
            font-size: 16px;
            border-radius: 4px;
            margin-top: 10px;
            text-align: center;
            text-decoration: none;
            cursor: pointer;
            transition: background 0.3s ease;
        }
        button:hover, a.button:hover {
            background: #0056b3;
        }
        /* تنسيق الجداول */
        table {
            width: 100%;
            max-width: 800px;
            border-collapse: collapse;
            margin: 20px auto;
        }
        table, th, td {
            border: 1px solid #444;
        }
        th, td {
            padding: 12px;
            text-align: center;
        }
        th {
            background: #2c2c2c;
            font-weight: normal;
        }
        td {
            background: #383838;
        }
        .actions {
            white-space: nowrap;
        }
        .actions form, .actions a {
            display: inline-block;
            vertical-align: middle;
        }
        .actions button {
            width: auto;
            padding: 6px 12px;
            font-size: 14px;
            margin: 0 3px;
            border-radius: 4px;
        }
        .actions button.delete {
            background: #e74c3c;
        }
        .actions a.edit {
            background: #3498db;
            padding: 6px 12px;
            border-radius: 4px;
            color: #fff;
        }
        @media (max-width: 600px) {
            form, table {
                width: 100%;
            }
        }
    </style>
</head>
<body>
    <h2>لوحة تحكم الأدمن</h2>
    <?php if ($message): ?>
        <p class="message"><?= $message ?></p>
    <?php endif; ?>

    <?php if ($editUser): ?>
        <!-- نموذج تعديل الأجهزة لمستخدم محدد -->
        <h3>تعديل الأجهزة للمستخدم: <?= htmlspecialchars($editUser['username']) ?></h3>
        <?php 
            $currentDevices = $editUser['allowed_devices'] ? array_map('trim', explode(',', $editUser['allowed_devices'])) : [];
        ?>
        <form method="POST" action="admin.php">
            <input type="hidden" name="action" value="update_devices">
            <input type="hidden" name="user_id" value="<?= $editUser['id'] ?>">
            <label>اختر الأجهزة المسموح بها:</label>
            <select name="allowed_devices[]" multiple>
                <?php foreach ($all_devices as $device): ?>
                    <?php $selected = in_array($device['device_id'], $currentDevices) ? 'selected' : ''; ?>
                    <option value="<?= $device['device_id'] ?>" <?= $selected ?>>
                        <?= htmlspecialchars($device['device_name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
            <button type="submit">تحديث الأجهزة</button>
            <a href="admin.php" class="button" style="background:#95a5a6; margin-top:10px;">إلغاء التعديل</a>
        </form>
    <?php else: ?>
        <!-- نموذج إضافة مستخدم جديد -->
        <h3>إضافة مستخدم جديد</h3>
        <form method="POST" action="admin.php">
            <input type="hidden" name="action" value="add_user">
            <label>اسم المستخدم:</label>
            <input type="text" name="new_username" required>
            <label>كلمة المرور:</label>
            <input type="password" name="new_password" required>
            <label>الدور:</label>
            <select name="new_role">
                <option value="user">مستخدم</option>
                <option value="admin">أدمن</option>
            </select>
            <label>الأجهزة المسموح بها (للمستخدمين):</label>
            <select name="allowed_devices[]" multiple>
                <?php foreach ($all_devices as $device): ?>
                    <option value="<?= $device['device_id'] ?>"><?= htmlspecialchars($device['device_name']) ?></option>
                <?php endforeach; ?>
            </select>
            <button type="submit">إضافة المستخدم</button>
        </form>
    
        <!-- جدول عرض المستخدمين الحاليين -->
        <h3>المستخدمين الحاليين</h3>
        <table>
            <tr>
                <th>المعرف</th>
                <th>اسم المستخدم</th>
                <th>الدور</th>
                <th>الأجهزة المسموح بها</th>
                <th>الإجراءات</th>
            </tr>
            <?php foreach ($users as $user): ?>
            <tr>
                <td><?= $user['id'] ?></td>
                <td><?= htmlspecialchars($user['username']) ?></td>
                <td><?= htmlspecialchars($user['role']) ?></td>
                <td><?= htmlspecialchars($user['allowed_devices']) ?></td>
                <td class="actions">
                    <?php if ($user['id'] != $_SESSION['user_id']): ?>
                        <form method="POST" action="admin.php" onsubmit="return confirm('هل أنت متأكد من حذف هذا المستخدم؟');">
                            <input type="hidden" name="action" value="delete_user">
                            <input type="hidden" name="user_id" value="<?= $user['id'] ?>">
                            <button type="submit" class="delete">حذف</button>
                        </form>
                        <a href="admin.php?edit_user=<?= $user['id'] ?>" class="edit">تعديل الأجهزة</a>
                    <?php else: ?>
                        <span>لا يمكن الحذف</span>
                    <?php endif; ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    <?php endif; ?>
    
    <p style="text-align:center;"><a href="dashboard.php" class="button" style="max-width:300px; margin:20px auto;">العودة إلى لوحة التتبع</a></p>
</body>
</html>
