<?php
header("Content-Type: application/json; charset=UTF-8");
require 'config.php'; // ملف الاتصال بقاعدة البيانات

try {
    $stmt = $conn->prepare("SELECT setting_value FROM settings WHERE setting_key = 'app_url' LIMIT 1");
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    $appUrl = $result ? $result['setting_value'] : null;

    echo json_encode([
        'status' => 'success',
        'appUrl' => $appUrl ?? ''
    ], JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ]);
}
